var chai = require('chai');
var utils = require('../lib/utils/utils.js');
var bloom = require('../lib/utils/bloom.js')
var assert = chai.assert;

var addressTests = [
	{bloom: '0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', address: '0xb794f5ea0ba39494ce839613fffba74279579268', result: false},
	{bloom: '0x0020008400000010000000000400000200000008000000000010000000002000000080000020000000080004000000010000000000000040000000000000000000000001000200008000000D000000000010000400000400000100000000000001400008220000000000004000040802004000200000000000000010000041000000020100008000000000000000000000000010000000080000000000800900000000000000000000000000100000800000000000000C28000000000000010000000002000040002000000080000000000000000000000020120020000020200000000040000000000000040000000400000000000000000000020000000000', address: '0x54D2C22A7E422DFC71D09D1557D4EBA6C9997D12', result: true},
	{bloom: '0x0020008400000010000000000400000200000008000000000010000000002000000080000020000000080004000000010000000000000040000000000000000000000001000200008000000D000000000010000400000400000100000000000001400008220000000000004000040802004000200000000000000010000041000000020100008000000000000000000000000010000000080000000000800900000000000000000000000000100000800000000000000C28000000000000010000000002000040002000000080000000000000000000000020120020000020200000000040000000000000040000000400000000000000000000020000000000', address: '0x54d2c22a7e422dfc71d09d1557d4eba6c9997d13', result: false}
];

describe('lib/utils/bloom', function() {
	describe('testAddress', function() {
		addressTests.forEach(function(test) {
			assert.equal(bloom.testAddress(test.bloom, test.address), test.result);
		});
	});
});